require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
-- class 
GameObject = {
--  
    Params = {
        ID="ground";
        width=3;
        height=1;
        health=5000;  -- 
        GridData= { 1, 1,1 };   -- do not change this parameter
        emotion=4;    -- do not change this parameter
        Impatience = 60; -- ammount of health that dissapers each second
        RandomTasks=3;
        group=3;
        next_product = "tomato";  --     (tomato,corn,pumpkin)
    };
    ActivePoints = { 
        tools = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
        weeding = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
    };
    Objects = {};
    --     
    Tasks = {
        tools = { FuncName="PlantTaskExecute", timer=1, time_tick=100, restore_health=1000, not_need_action=0 }; --not_need_action=1 };   
        weeding = { FuncName="WeedingTaskExecute", timer=1, time_tick=100, restore_health=1000, not_need_action=1 }; --not_need_action=1 };   
        switch_to_tomato = { FuncName="WaitOnTomato" }
    };
    --     
    Triggers = {
        Anger = {FuncName="AngerTriger", NotRunWhen={"tools","weeding"},active = 1 };
        DieObj = {FuncName="DieObjTriger", NotRunWhen={"tools","weeding"}, timer=2, time_tick=1000, active=0 };
    };
    --      
    InitActiveTasks = {};
    --      
    InitExpectedTasks = {};
    -- RandomTasks=3     
    Cycle = {
        index=0;
        index_sleep=0;
        max_index = 0;
    };
};
life_cycle = {
    { "weeding", 5 };
    { "tools", 5 };
    { "switch_to_tomato", 5000 };
};

function GameObject:Get()
    return self;
end


--        
function OnInit()
--    
aInitObject = GameObject:Get();
end


function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

function PlantTaskExecute()
    aObj = GameObject:Get();   
    SleepAfterTaskCycle();
    CPP_SetVisPrefix("");
    CPP_SetAnimState("plant_tablet_"..aObj.Params.next_product);
    CPP_SetAnimState("hide_heards");
    SwitchOnDieObjTriger();
    return 0;
end

function WeedingTaskExecute()
    aObj = GameObject:Get();
    CPP_SetAnimState("after_weeding");
    SleepAfterTaskCycle();
    return 0;
end

function SwitchOnDieObjTriger()
    aObj = GameObject:Get();
    local aTrigger = aObj.Triggers.DieObj;
    aTrigger.active = 1;
end

function WaitOnTomato()
--           
end

function DieObjTriger()
    aObj = GameObject:Get();
    local aTrigger = aObj.Triggers.DieObj;
    if (aTrigger.active == 0) then return; end
    --     ,   level    
    --   CustomTomato
    if (aObj.Params.next_product == "tomato") then
        CPP_RunStringParent("ChangeOnTomato("..aObj.Params.SubId..");");
    else 
        if (aObj.Params.next_product == "corn") then
            CPP_RunStringParent("ChangeOnCorn("..aObj.Params.SubId..");");
        else 
            if (aObj.Params.next_product == "pumpkin") then
                CPP_RunStringParent("ChangeOnPumpkin("..aObj.Params.SubId..");");
            end
        end
    end
    aTrigger.active = 0;
end

-- 
function AngerTriger()
    aObj = GameObject:Get();
    if (aObj.Triggers.Anger.active == 0)  then return; end;
    aObj.Params.health = aObj.Params.health - aObj.Params.Impatience;
    CPP_OnHealthChanged(aObj.Params.health);    
    if(aObj.Params.health<0)then aObj.Params.health = 0; end;   
end

function OnNextTask(aPrevTask, aNextTask)
    if (aNextTask=="tools") then        
        aObj = GameObject:Get();
        CPP_SetVisPrefix(aObj.Params.next_product);
    end;
end
